/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.MultichannelTcpConnection;
import com.zebra.sdk.comm.TcpConnection;
import com.zebra.sdk.comm.TcpStatusConnection;
import com.zebra.sdk.comm.internal.ConnectionReestablisherBase;
import com.zebra.sdk.printer.PrinterReconnectionHandler;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.ZebraPrinter;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.discovery.DiscoveryHandler;
import com.zebra.sdk.printer.discovery.NetworkDiscoverer;
import com.zebra.sdk.util.internal.NetworkUtil;
import com.zebra.sdk.util.internal.Sleeper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;

public class TcpConnectionReestablisher
extends ConnectionReestablisherBase
implements ConnectionReestablisher {
    public static final int INITIAL_DISCOVERY_TIMEOUT = 62;
    private String macAddr;

    public TcpConnectionReestablisher(Connection connection, long l) {
        super(connection, l);
        try {
            this.macAddr = this.getPrinterMacAddressViaDiscovery();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void reestablishConnection(PrinterReconnectionHandler printerReconnectionHandler) throws DiscoveryException, ConnectionException, TimeoutException, ZebraPrinterLanguageUnknownException {
        String string = this.waitForPrinterToComeOnlineViaSnmpAndSubnetDiscovery(this.macAddr);
        Sleeper.sleep(2500L);
        this.waitForConnectionToSucceed(string);
        Connection connection = this.getNewConnection(string);
        connection.open();
        String string2 = SGD.GET("appl.name", connection);
        ZebraPrinter zebraPrinter = ZebraPrinterFactory.getInstance(connection);
        ZebraPrinterLinkOs zebraPrinterLinkOs = ZebraPrinterFactory.createLinkOsPrinter(zebraPrinter);
        printerReconnectionHandler.printerOnline(zebraPrinterLinkOs, string2);
    }

    protected String getPrinterMacAddressViaDiscovery() throws DiscoveryException, ConnectionException, TimeoutException {
        String string = "";
        String string2 = this.getConnectionAddress();
        SinglePrinterDiscoveryHandler singlePrinterDiscoveryHandler = new SinglePrinterDiscoveryHandler();
        NetworkUtil.startSinglePrinterDiscovery(string2, singlePrinterDiscoveryHandler);
        for (int i = 0; i < 62 && !singlePrinterDiscoveryHandler.isFinished; ++i) {
            Sleeper.sleep(100L);
        }
        if (singlePrinterDiscoveryHandler.printer != null) {
            string = singlePrinterDiscoveryHandler.printer.getDiscoveryDataMap().get("HARDWARE_ADDRESS");
        }
        return string;
    }

    protected String waitForPrinterToComeOnlineViaSnmpAndSubnetDiscovery(String string) throws DiscoveryException, ConnectionException, TimeoutException {
        this.startTime = System.currentTimeMillis();
        FullSubnetDiscoveryHandler fullSubnetDiscoveryHandler = new FullSubnetDiscoveryHandler(string);
        SinglePrinterDiscoveryHandler singlePrinterDiscoveryHandler = new SinglePrinterDiscoveryHandler();
        block2: while (true) {
            this.timeoutCheck();
            fullSubnetDiscoveryHandler.isFinished = false;
            singlePrinterDiscoveryHandler.isFinished = false;
            NetworkDiscoverer.findPrinters(fullSubnetDiscoveryHandler);
            try {
                String string2 = this.zebraPrinterConnection.getSimpleConnectionName();
                NetworkDiscoverer.subnetSearch(singlePrinterDiscoveryHandler, InetAddress.getByName(string2).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                throw new DiscoveryException("Unkown Host: " + unknownHostException.getLocalizedMessage());
            }
            do {
                if (fullSubnetDiscoveryHandler.isFinished && singlePrinterDiscoveryHandler.isFinished) continue block2;
                Sleeper.sleep(100L);
                if (!fullSubnetDiscoveryHandler.isFinished || fullSubnetDiscoveryHandler.address == null) continue;
                return fullSubnetDiscoveryHandler.address;
            } while (!singlePrinterDiscoveryHandler.isFinished || singlePrinterDiscoveryHandler.printer == null);
            break;
        }
        return singlePrinterDiscoveryHandler.printer.address;
    }

    protected String getUpdatedFwVersion(String string) throws DiscoveryException, TimeoutException {
        SinglePrinterDiscoveryHandler singlePrinterDiscoveryHandler = new SinglePrinterDiscoveryHandler();
        NetworkUtil.startSinglePrinterDiscovery(string, singlePrinterDiscoveryHandler);
        while (!singlePrinterDiscoveryHandler.isFinished) {
            this.timeoutCheck();
            Sleeper.sleep(100L);
            if (!singlePrinterDiscoveryHandler.isFinished || singlePrinterDiscoveryHandler.printer != null) continue;
            singlePrinterDiscoveryHandler = new SinglePrinterDiscoveryHandler();
            NetworkUtil.startSinglePrinterDiscovery(string, singlePrinterDiscoveryHandler);
        }
        return singlePrinterDiscoveryHandler.printer.getDiscoveryDataMap().get("FIRMWARE_VER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForConnectionToSucceed(String string) throws TimeoutException {
        boolean bl = true;
        while (bl) {
            Connection connection = this.getNewConnection(string);
            try {
                connection.open();
                bl = false;
            }
            catch (ConnectionException connectionException) {
                this.timeoutCheck();
            }
            finally {
                try {
                    connection.close();
                }
                catch (ConnectionException connectionException) {}
            }
        }
    }

    protected Connection getNewConnection(String string) {
        String string2 = this.getConnectionPortNumber();
        if (this.zebraPrinterConnection instanceof TcpStatusConnection) {
            return new TcpStatusConnection(string, Integer.parseInt(string2));
        }
        return new TcpConnection(string, Integer.parseInt(string2));
    }

    protected String getConnectionPortNumber() {
        return ((TcpConnection)this.zebraPrinterConnection).getPortNumber();
    }

    protected String getConnectionAddress() {
        if (this.zebraPrinterConnection instanceof TcpConnection) {
            return ((TcpConnection)this.zebraPrinterConnection).getAddress();
        }
        if (this.zebraPrinterConnection instanceof MultichannelTcpConnection) {
            Connection connection = ((MultichannelTcpConnection)this.zebraPrinterConnection).getPrintingChannel();
            return ((TcpConnection)connection).getAddress();
        }
        return "";
    }

    private final class FullSubnetDiscoveryHandler
    implements DiscoveryHandler {
        public boolean isFinished = false;
        public String address;
        private String macAddress;

        public FullSubnetDiscoveryHandler(String string) {
            this.macAddress = string;
        }

        @Override
        public void foundPrinter(DiscoveredPrinter discoveredPrinter) {
            if (this.macAddress != null && discoveredPrinter.getDiscoveryDataMap().get("HARDWARE_ADDRESS").equals(this.macAddress)) {
                this.address = discoveredPrinter.address;
                this.isFinished = true;
            }
        }

        @Override
        public void discoveryFinished() {
            this.isFinished = true;
        }

        @Override
        public void discoveryError(String string) {
            this.isFinished = true;
        }
    }

    private final class SinglePrinterDiscoveryHandler
    implements DiscoveryHandler {
        public boolean isFinished = false;
        public DiscoveredPrinter printer;

        private SinglePrinterDiscoveryHandler() {
        }

        @Override
        public void foundPrinter(DiscoveredPrinter discoveredPrinter) {
            this.printer = discoveredPrinter;
            this.isFinished = true;
        }

        @Override
        public void discoveryFinished() {
            this.isFinished = true;
        }

        @Override
        public void discoveryError(String string) {
            this.isFinished = true;
        }
    }
}

