/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.graphics.ZebraImageI;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ReflectionUtil {
    public static Set<Class<?>> getClassesInPackage(String string) throws ClassNotFoundException, IOException {
        return new HashSet(Arrays.asList(ReflectionUtil.getClasses(string)));
    }

    public static Set<Class<?>> getClassesInPackageExtending(String string, Class<?> clazz) throws ClassNotFoundException, IOException {
        Set<Class<?>> set = ReflectionUtil.getClassesInPackage(string);
        Iterator<Class<?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz2 = iterator.next();
            if (!Modifier.isAbstract(clazz2.getModifiers()) && clazz.isAssignableFrom(clazz2)) continue;
            iterator.remove();
        }
        return set;
    }

    private static Class<?>[] getClasses(String string) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String string2 = string.replace('.', '/');
        URL uRL = classLoader.getResource(string2);
        ArrayList arrayList = new ArrayList();
        if (uRL.getProtocol().equals("jar")) {
            String string3 = URLDecoder.decode(uRL.getFile(), "UTF-8");
            string3 = string3.substring(5, string3.indexOf("!"));
            JarFile jarFile = new JarFile(string3);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string4 = enumeration.nextElement().getName();
                if (!string4.startsWith(string2) || string4.length() <= string2.length() + 5 || !string4.endsWith(".class")) continue;
                String string5 = string4.replace('/', '.');
                arrayList.add(Class.forName(string5.substring(0, string5.length() - 6)));
            }
            jarFile.close();
        } else {
            Enumeration<URL> enumeration = classLoader.getResources(string2);
            ArrayList<File> arrayList2 = new ArrayList<File>();
            while (enumeration.hasMoreElements()) {
                URL uRL2 = enumeration.nextElement();
                arrayList2.add(new File(uRL2.getFile()));
            }
            for (File file : arrayList2) {
                arrayList.addAll(ReflectionUtil.findClasses(file, string));
            }
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private static List<Class<?>> findClasses(File file, String string) throws ClassNotFoundException {
        File[] fileArray;
        ArrayList arrayList = new ArrayList();
        if (!file.exists()) {
            return arrayList;
        }
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                assert (!file2.getName().contains("."));
                arrayList.addAll(ReflectionUtil.findClasses(file2, string + "." + file2.getName()));
                continue;
            }
            if (!file2.getName().endsWith(".class")) continue;
            arrayList.add(Class.forName(string + '.' + file2.getName().substring(0, file2.getName().length() - 6)));
        }
        return arrayList;
    }

    public static ZebraImageI invokeZebraImageFactory_getImage(String string) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("com.zebra.sdk.graphics.ZebraImageFactory");
            Method method = clazz.getMethod("getImage", String.class);
            Object object = method.invoke(null, string);
            return (ZebraImageI)object;
        }
        catch (Exception exception) {
            throw new IOException(exception.getCause().getLocalizedMessage());
        }
    }

    public static ZebraImageI invokeZebraImageFactory_getImage(InputStream inputStream) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("com.zebra.sdk.graphics.ZebraImageFactory");
            Method method = clazz.getMethod("getImage", InputStream.class);
            Object object = method.invoke(null, inputStream);
            return (ZebraImageI)object;
        }
        catch (Exception exception) {
            throw new IOException(exception.getCause().getLocalizedMessage());
        }
    }

    public static boolean isDriverConnection(Connection connection) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("com.zebra.sdk.comm.DriverPrinterConnection");
            return clazz.isInstance(connection);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isUsbConnection(Connection connection) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("com.zebra.sdk.comm.UsbConnection");
            return clazz.isInstance(connection);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ConnectionReestablisher loadTcpCardConnectionReestablisher(Connection connection, long l) {
        try {
            Class<?> clazz = Class.forName("com.zebra.sdk.common.card.comm.internal.TcpCardConnectionReestablisher");
            Constructor<?> constructor = clazz.getDeclaredConstructor(Connection.class, Long.class);
            constructor.setAccessible(true);
            return (ConnectionReestablisher)constructor.newInstance(connection, l);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ConnectionReestablisher loadUsbCardConnectionReestablisher(Connection connection, long l) {
        try {
            Class<?> clazz = Class.forName("com.zebra.sdk.common.card.comm.internal.UsbCardConnectionReestablisher");
            Constructor<?> constructor = clazz.getDeclaredConstructor(Connection.class, Long.class);
            constructor.setAccessible(true);
            return (ConnectionReestablisher)constructor.newInstance(connection, l);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Map<String, String> invokeUsbConnection_getConnectionAttributes(Connection connection) throws IOException {
        Map map = null;
        try {
            Class<?> clazz = Class.forName("com.zebra.sdk.comm.UsbConnection");
            Method method = clazz.getDeclaredMethod("getConnectionAttributes", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)connection, new Object[0]);
            if (object instanceof Map) {
                map = (Map)object;
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getCause().getLocalizedMessage());
        }
        return map;
    }

    public static String getSymbolicNameFromSerialNumber(String string) {
        String string2 = "";
        try {
            DiscoveredPrinter[] discoveredPrinterArray;
            Class<?> clazz = Class.forName("com.zebra.sdk.printer.discovery.UsbDiscoverer");
            Method method = clazz.getDeclaredMethod("getZebraUsbPrinters", new Class[0]);
            for (DiscoveredPrinter discoveredPrinter : discoveredPrinterArray = (DiscoveredPrinter[])method.invoke(null, new Object[0])) {
                Map<String, String> map = discoveredPrinter.getDiscoveryDataMap();
                if (!string.equalsIgnoreCase(map.get("SERIAL_NUMBER"))) continue;
                string2 = map.get("ADDRESS");
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }
}

