/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;

public class PrinterPngToGrfConverterStream
extends InputStream {
    int headerCount = 0;
    private InputStream pngStream;
    int[] zebraHeader = new int[]{0, 0, 0, 0};
    private ByteArrayInputStream grfStream;

    public PrinterPngToGrfConverterStream(InputStream inputStream) {
        this.pngStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.headerCount < 4) {
            int n = this.pngStream.read();
            this.zebraHeader[this.headerCount++] = n;
            return n;
        }
        if (this.headerCount == 4) {
            ++this.headerCount;
            byte[] byArray = this.pngToGrf(this.pngStream);
            this.grfStream = new ByteArrayInputStream(byArray);
        }
        return this.grfStream.read();
    }

    private byte[] pngToGrf(InputStream inputStream) {
        Class<?> clazz = null;
        try {
            try {
                clazz = Class.forName("com.zebra.sdk.graphics.internal.PngToGrfConverterDesktop");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("com.zebra.sdk.graphics.internal.PngToGrfConverterAndroid");
            }
            Method method = clazz.getMethod("pngToGrf", InputStream.class);
            return (byte[])method.invoke(null, inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

