/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RleEncodedImage {
    private ByteArrayOutputStream outputImageByteStream = new ByteArrayOutputStream();

    public byte[] rleEncoding(byte[] byArray, int n) throws IOException {
        boolean bl = n % 2 != 0;
        byte by = 0;
        for (int i = 0; i < byArray.length; i += n) {
            byte[] byArray2;
            int n2;
            int n3 = byArray.length - i;
            int n4 = n2 = n3 < n ? n3 : n;
            if (bl) {
                byArray2 = new byte[n2 + 1];
                for (int j = 0; j < n2; ++j) {
                    byArray2[j] = byArray[i + j];
                }
                byArray2[n2] = by;
            } else {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, i, byArray2, 0, byArray2.length);
            }
            DataBuffer dataBuffer = new DataBuffer(byArray2);
            this.rleEncoding(dataBuffer);
        }
        byte[] byArray3 = this.outputImageByteStream.toByteArray();
        this.outputImageByteStream.close();
        return byArray3;
    }

    private void rleEncoding(DataBuffer dataBuffer) {
        byte[] byArray = this.getNextElement(dataBuffer);
        this.outputElement(byArray);
        if (dataBuffer.bytesLeft() > 0) {
            this.rleEncoding(dataBuffer);
        }
    }

    private byte[] getNextElement(DataBuffer dataBuffer) {
        byte by = dataBuffer.getByte();
        byte[] byArray = dataBuffer.bytesLeft() > 0 && by == dataBuffer.peek() ? this.encodeRun(by, dataBuffer) : (this.bothUpperBitsAreSet(by) ? this.createRun(1, by) : new byte[]{by});
        return byArray;
    }

    private byte[] encodeRun(byte by, DataBuffer dataBuffer) {
        int n;
        for (n = 1; dataBuffer.bytesLeft() > 0 && by == dataBuffer.peek() && n < 63; ++n) {
            dataBuffer.getByte();
        }
        return this.createRun(n, by);
    }

    private byte[] createRun(int n, byte by) {
        byte by2 = (byte)((byte)n | 0xC0);
        byte[] byArray = new byte[]{by2, by};
        return byArray;
    }

    private boolean bothUpperBitsAreSet(byte by) {
        return (by & 0xC0) == 192;
    }

    private void outputElement(byte[] byArray) {
        this.outputImageByteStream.write(byArray, 0, byArray.length);
    }

    public class DataBuffer {
        byte[] imageData;
        int currentIndex = 0;

        public DataBuffer(byte[] byArray) {
            this.imageData = byArray;
        }

        public byte getByte() {
            return this.imageData[this.currentIndex++];
        }

        private int bytesLeft() {
            return this.imageData.length - this.currentIndex;
        }

        private byte peek() {
            return this.imageData[this.currentIndex];
        }
    }
}

