/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.util.internal.Extension;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.StringUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DZHeader {
    private static final byte blank = 0;

    private DZHeader() {
    }

    public static byte[] getHeader(byte[] byArray, String string, boolean bl, boolean bl2) throws ZebraIllegalArgumentException {
        return DZHeader.getHeaderHelper(DZHeader.getLength(byArray), string, bl, bl2);
    }

    private static byte[] getHeaderHelper(byte[] byArray, String string, boolean bl, boolean bl2) throws ZebraIllegalArgumentException {
        String string2 = FileUtilities.parseDriveAndExtension(string).getFileName();
        int n = string2.length() > 8 ? 17 : 9;
        String string3 = StringUtilities.stringPadToPlaces(n, '\u0000', string2, true);
        byte by = DZHeader.getFlags(bl, bl2, string2);
        byte by2 = DZHeader.getType(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(string3.getBytes());
            byteArrayOutputStream.write(by);
            byteArrayOutputStream.write(by2);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte getFlags(boolean bl, boolean bl2, String string) {
        byte by = 0;
        if (bl) {
            by = (byte)(by | 0x40);
        }
        if (bl2) {
            by = (byte)(by | 0x20);
        }
        if (string.length() > 8) {
            by = (byte)(by | 8);
        }
        return by;
    }

    private static byte[] getLength(byte[] byArray) {
        return DZHeader.getLength(byArray.length);
    }

    private static byte[] getLength(int n) {
        byte[] byArray = BigInteger.valueOf(n).toByteArray();
        byte[] byArray2 = StringUtilities.byteArrayPadToPlaces(4, byArray);
        return byArray2;
    }

    private static byte getType(String string) {
        String string2 = "";
        if (string.contains(".")) {
            string2 = string.substring(string.lastIndexOf(46) + 1);
        }
        return (byte)Extension.getTypeValue(string2);
    }
}

