/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.CsvPrinter;
import com.zebra.sdk.printer.XmlPrinter;
import com.zebra.sdk.util.internal.Range;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TemplateCommand
extends Command {
    private static final Option SAVE_OPTION = new Option("s", "save", "Save output to file").addArg("filePath", true);
    private static final Option XML_OPTION = new Option("x", "xml", "XML print");
    private static final Option CSV_OPTION = new Option("c", "csv", "CSV print");
    private static final int TEMPLATE_ARG_INDEX = 1;
    private static final int XML_CSV_FILE_INDEX = 0;

    public TemplateCommand() {
        this.addOptions(SAVE_OPTION, XML_OPTION, CSV_OPTION);
        this.groups.add(new OptionGroup().createGroup(XML_OPTION, CSV_OPTION));
    }

    @Override
    public String getCommandName() {
        return "template";
    }

    @Override
    public String getDescription() {
        return "Fill in a zpl/cpcl template file with xml or csv";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        this.checkFilesExist(parsedArguments.getArg(0), parsedArguments.getArg(1));
        if (parsedArguments.containsOption(XML_OPTION)) {
            this.verbosePrint("Processing as XML.");
            this.doXmlTemplate(parsedArguments);
        } else if (parsedArguments.containsOption(CSV_OPTION)) {
            this.verbosePrint("Processing as CSV.");
            this.doCsvTemplate(parsedArguments);
        } else {
            throw new IllegalArgumentException(String.format("Must specify either --%s or --%s", XML_OPTION.getLongName(), CSV_OPTION.getLongName()));
        }
    }

    private void doCsvTemplate(ParsedArguments parsedArguments) throws FileNotFoundException, IOException, ConnectionException {
        CsvPrinter.print(new FileInputStream(parsedArguments.getArg(0)), parsedArguments.getArg(1), "1", this.getOutputStream(parsedArguments));
    }

    private void doXmlTemplate(ParsedArguments parsedArguments) throws FileNotFoundException {
        XmlPrinter.print(new FileInputStream(parsedArguments.getArg(0)), parsedArguments.getArg(1), "1", this.getOutputStream(parsedArguments));
    }

    private void checkFilesExist(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        this.verbosePrint("Checking valid file paths...");
        if (!file.exists() || !file2.exists()) {
            throw new IllegalArgumentException("Must specify a valid data and template file.");
        }
        this.verbosePrint("Valid.");
    }

    private OutputStream getOutputStream(ParsedArguments parsedArguments) throws FileNotFoundException {
        if (parsedArguments.containsOption(SAVE_OPTION)) {
            String string = parsedArguments.getOptionArgument(SAVE_OPTION);
            this.verboseFormatPrint("Printing processed template to %s%n", string);
            return new FileOutputStream(string);
        }
        this.verbosePrint("Printing processed template to standard output.");
        return System.out;
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <csvOrXmlFile> <templateFile> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process zpl template with XML data, outputting to command line\n");
        stringBuilder.append(String.format("\t%s %s /path/to/data.xml /path/to/template.zpl --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), XML_OPTION.getLongName()));
        stringBuilder.append("Process zpl template with CSV data, saving to file\n");
        stringBuilder.append(String.format("\t%s %s /path/to/data.csv /path/to/template.zpl --%s /path/to/save.zpl --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), SAVE_OPTION.getLongName(), CSV_OPTION.getLongName()));
        return stringBuilder.toString();
    }
}

