/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.objdetect.QRCodeEncoder_Params;
import org.opencv.utils.Converters;

public class QRCodeEncoder {
    protected final long nativeObj;
    public static final int CORRECT_LEVEL_L = 0;
    public static final int CORRECT_LEVEL_M = 1;
    public static final int CORRECT_LEVEL_Q = 2;
    public static final int CORRECT_LEVEL_H = 3;
    public static final int ECI_SHIFT_JIS = 20;
    public static final int ECI_UTF8 = 26;
    public static final int MODE_AUTO = -1;
    public static final int MODE_NUMERIC = 1;
    public static final int MODE_ALPHANUMERIC = 2;
    public static final int MODE_BYTE = 4;
    public static final int MODE_ECI = 7;
    public static final int MODE_KANJI = 8;
    public static final int MODE_STRUCTURED_APPEND = 3;

    protected QRCodeEncoder(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static QRCodeEncoder __fromPtr__(long addr) {
        return new QRCodeEncoder(addr);
    }

    public static QRCodeEncoder create(QRCodeEncoder_Params parameters) {
        return QRCodeEncoder.__fromPtr__(QRCodeEncoder.create_0(parameters.getNativeObjAddr()));
    }

    public static QRCodeEncoder create() {
        return QRCodeEncoder.__fromPtr__(QRCodeEncoder.create_1());
    }

    public void encode(String encoded_info, Mat qrcode) {
        QRCodeEncoder.encode_0(this.nativeObj, encoded_info, qrcode.nativeObj);
    }

    public void encodeStructuredAppend(String encoded_info, List<Mat> qrcodes) {
        Mat qrcodes_mat = new Mat();
        QRCodeEncoder.encodeStructuredAppend_0(this.nativeObj, encoded_info, qrcodes_mat.nativeObj);
        Converters.Mat_to_vector_Mat(qrcodes_mat, qrcodes);
        qrcodes_mat.release();
    }

    public void encode(byte[] encoded_info, Mat qrcode) {
        QRCodeEncoder.encode_1(this.nativeObj, encoded_info, qrcode.nativeObj);
    }

    protected void finalize() throws Throwable {
        QRCodeEncoder.delete(this.nativeObj);
    }

    private static native long create_0(long var0);

    private static native long create_1();

    private static native void encode_0(long var0, String var2, long var3);

    private static native void encodeStructuredAppend_0(long var0, String var2, long var3);

    private static native void encode_1(long var0, byte[] var2, long var3);

    private static native void delete(long var0);
}

