/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint3f;
import org.opencv.core.Size;
import org.opencv.objdetect.Board;
import org.opencv.objdetect.Dictionary;

public class CharucoBoard
extends Board {
    protected CharucoBoard(long addr) {
        super(addr);
    }

    public static CharucoBoard __fromPtr__(long addr) {
        return new CharucoBoard(addr);
    }

    public CharucoBoard(Size size, float squareLength, float markerLength, Dictionary dictionary, Mat ids) {
        super(CharucoBoard.CharucoBoard_0(size.width, size.height, squareLength, markerLength, dictionary.getNativeObjAddr(), ids.nativeObj));
    }

    public CharucoBoard(Size size, float squareLength, float markerLength, Dictionary dictionary) {
        super(CharucoBoard.CharucoBoard_1(size.width, size.height, squareLength, markerLength, dictionary.getNativeObjAddr()));
    }

    public void setLegacyPattern(boolean legacyPattern) {
        CharucoBoard.setLegacyPattern_0(this.nativeObj, legacyPattern);
    }

    public boolean getLegacyPattern() {
        return CharucoBoard.getLegacyPattern_0(this.nativeObj);
    }

    public Size getChessboardSize() {
        return new Size(CharucoBoard.getChessboardSize_0(this.nativeObj));
    }

    public float getSquareLength() {
        return CharucoBoard.getSquareLength_0(this.nativeObj);
    }

    public float getMarkerLength() {
        return CharucoBoard.getMarkerLength_0(this.nativeObj);
    }

    public MatOfPoint3f getChessboardCorners() {
        return MatOfPoint3f.fromNativeAddr(CharucoBoard.getChessboardCorners_0(this.nativeObj));
    }

    public boolean checkCharucoCornersCollinear(Mat charucoIds) {
        return CharucoBoard.checkCharucoCornersCollinear_0(this.nativeObj, charucoIds.nativeObj);
    }

    @Override
    protected void finalize() throws Throwable {
        CharucoBoard.delete(this.nativeObj);
    }

    private static native long CharucoBoard_0(double var0, double var2, float var4, float var5, long var6, long var8);

    private static native long CharucoBoard_1(double var0, double var2, float var4, float var5, long var6);

    private static native void setLegacyPattern_0(long var0, boolean var2);

    private static native boolean getLegacyPattern_0(long var0);

    private static native double[] getChessboardSize_0(long var0);

    private static native float getSquareLength_0(long var0);

    private static native float getMarkerLength_0(long var0);

    private static native long getChessboardCorners_0(long var0);

    private static native boolean checkCharucoCornersCollinear_0(long var0, long var2);

    private static native void delete(long var0);
}

