/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.objdetect.Board;
import org.opencv.objdetect.DetectorParameters;
import org.opencv.objdetect.Dictionary;
import org.opencv.objdetect.RefineParameters;
import org.opencv.utils.Converters;

public class ArucoDetector
extends Algorithm {
    protected ArucoDetector(long addr) {
        super(addr);
    }

    public static ArucoDetector __fromPtr__(long addr) {
        return new ArucoDetector(addr);
    }

    public ArucoDetector(Dictionary dictionary, DetectorParameters detectorParams, RefineParameters refineParams) {
        super(ArucoDetector.ArucoDetector_0(dictionary.getNativeObjAddr(), detectorParams.getNativeObjAddr(), refineParams.getNativeObjAddr()));
    }

    public ArucoDetector(Dictionary dictionary, DetectorParameters detectorParams) {
        super(ArucoDetector.ArucoDetector_1(dictionary.getNativeObjAddr(), detectorParams.getNativeObjAddr()));
    }

    public ArucoDetector(Dictionary dictionary) {
        super(ArucoDetector.ArucoDetector_2(dictionary.getNativeObjAddr()));
    }

    public ArucoDetector() {
        super(ArucoDetector.ArucoDetector_3());
    }

    public void detectMarkers(Mat image, List<Mat> corners, Mat ids, List<Mat> rejectedImgPoints) {
        Mat corners_mat = new Mat();
        Mat rejectedImgPoints_mat = new Mat();
        ArucoDetector.detectMarkers_0(this.nativeObj, image.nativeObj, corners_mat.nativeObj, ids.nativeObj, rejectedImgPoints_mat.nativeObj);
        Converters.Mat_to_vector_Mat(corners_mat, corners);
        corners_mat.release();
        Converters.Mat_to_vector_Mat(rejectedImgPoints_mat, rejectedImgPoints);
        rejectedImgPoints_mat.release();
    }

    public void detectMarkers(Mat image, List<Mat> corners, Mat ids) {
        Mat corners_mat = new Mat();
        ArucoDetector.detectMarkers_1(this.nativeObj, image.nativeObj, corners_mat.nativeObj, ids.nativeObj);
        Converters.Mat_to_vector_Mat(corners_mat, corners);
        corners_mat.release();
    }

    public void refineDetectedMarkers(Mat image, Board board, List<Mat> detectedCorners, Mat detectedIds, List<Mat> rejectedCorners, Mat cameraMatrix, Mat distCoeffs, Mat recoveredIdxs) {
        Mat detectedCorners_mat = Converters.vector_Mat_to_Mat(detectedCorners);
        Mat rejectedCorners_mat = Converters.vector_Mat_to_Mat(rejectedCorners);
        ArucoDetector.refineDetectedMarkers_0(this.nativeObj, image.nativeObj, board.getNativeObjAddr(), detectedCorners_mat.nativeObj, detectedIds.nativeObj, rejectedCorners_mat.nativeObj, cameraMatrix.nativeObj, distCoeffs.nativeObj, recoveredIdxs.nativeObj);
        Converters.Mat_to_vector_Mat(detectedCorners_mat, detectedCorners);
        detectedCorners_mat.release();
        Converters.Mat_to_vector_Mat(rejectedCorners_mat, rejectedCorners);
        rejectedCorners_mat.release();
    }

    public void refineDetectedMarkers(Mat image, Board board, List<Mat> detectedCorners, Mat detectedIds, List<Mat> rejectedCorners, Mat cameraMatrix, Mat distCoeffs) {
        Mat detectedCorners_mat = Converters.vector_Mat_to_Mat(detectedCorners);
        Mat rejectedCorners_mat = Converters.vector_Mat_to_Mat(rejectedCorners);
        ArucoDetector.refineDetectedMarkers_1(this.nativeObj, image.nativeObj, board.getNativeObjAddr(), detectedCorners_mat.nativeObj, detectedIds.nativeObj, rejectedCorners_mat.nativeObj, cameraMatrix.nativeObj, distCoeffs.nativeObj);
        Converters.Mat_to_vector_Mat(detectedCorners_mat, detectedCorners);
        detectedCorners_mat.release();
        Converters.Mat_to_vector_Mat(rejectedCorners_mat, rejectedCorners);
        rejectedCorners_mat.release();
    }

    public void refineDetectedMarkers(Mat image, Board board, List<Mat> detectedCorners, Mat detectedIds, List<Mat> rejectedCorners, Mat cameraMatrix) {
        Mat detectedCorners_mat = Converters.vector_Mat_to_Mat(detectedCorners);
        Mat rejectedCorners_mat = Converters.vector_Mat_to_Mat(rejectedCorners);
        ArucoDetector.refineDetectedMarkers_2(this.nativeObj, image.nativeObj, board.getNativeObjAddr(), detectedCorners_mat.nativeObj, detectedIds.nativeObj, rejectedCorners_mat.nativeObj, cameraMatrix.nativeObj);
        Converters.Mat_to_vector_Mat(detectedCorners_mat, detectedCorners);
        detectedCorners_mat.release();
        Converters.Mat_to_vector_Mat(rejectedCorners_mat, rejectedCorners);
        rejectedCorners_mat.release();
    }

    public void refineDetectedMarkers(Mat image, Board board, List<Mat> detectedCorners, Mat detectedIds, List<Mat> rejectedCorners) {
        Mat detectedCorners_mat = Converters.vector_Mat_to_Mat(detectedCorners);
        Mat rejectedCorners_mat = Converters.vector_Mat_to_Mat(rejectedCorners);
        ArucoDetector.refineDetectedMarkers_3(this.nativeObj, image.nativeObj, board.getNativeObjAddr(), detectedCorners_mat.nativeObj, detectedIds.nativeObj, rejectedCorners_mat.nativeObj);
        Converters.Mat_to_vector_Mat(detectedCorners_mat, detectedCorners);
        detectedCorners_mat.release();
        Converters.Mat_to_vector_Mat(rejectedCorners_mat, rejectedCorners);
        rejectedCorners_mat.release();
    }

    public void detectMarkersMultiDict(Mat image, List<Mat> corners, Mat ids, List<Mat> rejectedImgPoints, Mat dictIndices) {
        Mat corners_mat = new Mat();
        Mat rejectedImgPoints_mat = new Mat();
        ArucoDetector.detectMarkersMultiDict_0(this.nativeObj, image.nativeObj, corners_mat.nativeObj, ids.nativeObj, rejectedImgPoints_mat.nativeObj, dictIndices.nativeObj);
        Converters.Mat_to_vector_Mat(corners_mat, corners);
        corners_mat.release();
        Converters.Mat_to_vector_Mat(rejectedImgPoints_mat, rejectedImgPoints);
        rejectedImgPoints_mat.release();
    }

    public void detectMarkersMultiDict(Mat image, List<Mat> corners, Mat ids, List<Mat> rejectedImgPoints) {
        Mat corners_mat = new Mat();
        Mat rejectedImgPoints_mat = new Mat();
        ArucoDetector.detectMarkersMultiDict_1(this.nativeObj, image.nativeObj, corners_mat.nativeObj, ids.nativeObj, rejectedImgPoints_mat.nativeObj);
        Converters.Mat_to_vector_Mat(corners_mat, corners);
        corners_mat.release();
        Converters.Mat_to_vector_Mat(rejectedImgPoints_mat, rejectedImgPoints);
        rejectedImgPoints_mat.release();
    }

    public void detectMarkersMultiDict(Mat image, List<Mat> corners, Mat ids) {
        Mat corners_mat = new Mat();
        ArucoDetector.detectMarkersMultiDict_2(this.nativeObj, image.nativeObj, corners_mat.nativeObj, ids.nativeObj);
        Converters.Mat_to_vector_Mat(corners_mat, corners);
        corners_mat.release();
    }

    public Dictionary getDictionary() {
        return new Dictionary(ArucoDetector.getDictionary_0(this.nativeObj));
    }

    public void setDictionary(Dictionary dictionary) {
        ArucoDetector.setDictionary_0(this.nativeObj, dictionary.getNativeObjAddr());
    }

    public DetectorParameters getDetectorParameters() {
        return new DetectorParameters(ArucoDetector.getDetectorParameters_0(this.nativeObj));
    }

    public void setDetectorParameters(DetectorParameters detectorParameters) {
        ArucoDetector.setDetectorParameters_0(this.nativeObj, detectorParameters.getNativeObjAddr());
    }

    public RefineParameters getRefineParameters() {
        return new RefineParameters(ArucoDetector.getRefineParameters_0(this.nativeObj));
    }

    public void setRefineParameters(RefineParameters refineParameters) {
        ArucoDetector.setRefineParameters_0(this.nativeObj, refineParameters.getNativeObjAddr());
    }

    @Override
    protected void finalize() throws Throwable {
        ArucoDetector.delete(this.nativeObj);
    }

    private static native long ArucoDetector_0(long var0, long var2, long var4);

    private static native long ArucoDetector_1(long var0, long var2);

    private static native long ArucoDetector_2(long var0);

    private static native long ArucoDetector_3();

    private static native void detectMarkers_0(long var0, long var2, long var4, long var6, long var8);

    private static native void detectMarkers_1(long var0, long var2, long var4, long var6);

    private static native void refineDetectedMarkers_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    private static native void refineDetectedMarkers_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native void refineDetectedMarkers_2(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native void refineDetectedMarkers_3(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void detectMarkersMultiDict_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void detectMarkersMultiDict_1(long var0, long var2, long var4, long var6, long var8);

    private static native void detectMarkersMultiDict_2(long var0, long var2, long var4, long var6);

    private static native long getDictionary_0(long var0);

    private static native void setDictionary_0(long var0, long var2);

    private static native long getDetectorParameters_0(long var0);

    private static native void setDetectorParameters_0(long var0, long var2);

    private static native long getRefineParameters_0(long var0);

    private static native void setRefineParameters_0(long var0, long var2);

    private static native void delete(long var0);
}

