/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.imgcodecs;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfInt;
import org.opencv.core.Range;
import org.opencv.imgcodecs.Animation;
import org.opencv.utils.Converters;

public class Imgcodecs {
    public static final int IMAGE_METADATA_UNKNOWN = -1;
    public static final int IMAGE_METADATA_EXIF = 0;
    public static final int IMAGE_METADATA_XMP = 1;
    public static final int IMAGE_METADATA_ICCP = 2;
    public static final int IMAGE_METADATA_MAX = 2;
    public static final int IMREAD_UNCHANGED = -1;
    public static final int IMREAD_GRAYSCALE = 0;
    public static final int IMREAD_COLOR_BGR = 1;
    public static final int IMREAD_COLOR = 1;
    public static final int IMREAD_ANYDEPTH = 2;
    public static final int IMREAD_ANYCOLOR = 4;
    public static final int IMREAD_LOAD_GDAL = 8;
    public static final int IMREAD_REDUCED_GRAYSCALE_2 = 16;
    public static final int IMREAD_REDUCED_COLOR_2 = 17;
    public static final int IMREAD_REDUCED_GRAYSCALE_4 = 32;
    public static final int IMREAD_REDUCED_COLOR_4 = 33;
    public static final int IMREAD_REDUCED_GRAYSCALE_8 = 64;
    public static final int IMREAD_REDUCED_COLOR_8 = 65;
    public static final int IMREAD_IGNORE_ORIENTATION = 128;
    public static final int IMREAD_COLOR_RGB = 256;
    public static final int IMWRITE_EXR_COMPRESSION_NO = 0;
    public static final int IMWRITE_EXR_COMPRESSION_RLE = 1;
    public static final int IMWRITE_EXR_COMPRESSION_ZIPS = 2;
    public static final int IMWRITE_EXR_COMPRESSION_ZIP = 3;
    public static final int IMWRITE_EXR_COMPRESSION_PIZ = 4;
    public static final int IMWRITE_EXR_COMPRESSION_PXR24 = 5;
    public static final int IMWRITE_EXR_COMPRESSION_B44 = 6;
    public static final int IMWRITE_EXR_COMPRESSION_B44A = 7;
    public static final int IMWRITE_EXR_COMPRESSION_DWAA = 8;
    public static final int IMWRITE_EXR_COMPRESSION_DWAB = 9;
    public static final int IMWRITE_EXR_TYPE_HALF = 1;
    public static final int IMWRITE_EXR_TYPE_FLOAT = 2;
    public static final int IMWRITE_JPEG_QUALITY = 1;
    public static final int IMWRITE_JPEG_PROGRESSIVE = 2;
    public static final int IMWRITE_JPEG_OPTIMIZE = 3;
    public static final int IMWRITE_JPEG_RST_INTERVAL = 4;
    public static final int IMWRITE_JPEG_LUMA_QUALITY = 5;
    public static final int IMWRITE_JPEG_CHROMA_QUALITY = 6;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR = 7;
    public static final int IMWRITE_PNG_COMPRESSION = 16;
    public static final int IMWRITE_PNG_STRATEGY = 17;
    public static final int IMWRITE_PNG_BILEVEL = 18;
    public static final int IMWRITE_PNG_FILTER = 19;
    public static final int IMWRITE_PXM_BINARY = 32;
    public static final int IMWRITE_EXR_TYPE = 48;
    public static final int IMWRITE_EXR_COMPRESSION = 49;
    public static final int IMWRITE_EXR_DWA_COMPRESSION_LEVEL = 50;
    public static final int IMWRITE_WEBP_QUALITY = 64;
    public static final int IMWRITE_HDR_COMPRESSION = 80;
    public static final int IMWRITE_PAM_TUPLETYPE = 128;
    public static final int IMWRITE_TIFF_RESUNIT = 256;
    public static final int IMWRITE_TIFF_XDPI = 257;
    public static final int IMWRITE_TIFF_YDPI = 258;
    public static final int IMWRITE_TIFF_COMPRESSION = 259;
    public static final int IMWRITE_TIFF_ROWSPERSTRIP = 278;
    public static final int IMWRITE_TIFF_PREDICTOR = 317;
    public static final int IMWRITE_JPEG2000_COMPRESSION_X1000 = 272;
    public static final int IMWRITE_AVIF_QUALITY = 512;
    public static final int IMWRITE_AVIF_DEPTH = 513;
    public static final int IMWRITE_AVIF_SPEED = 514;
    public static final int IMWRITE_JPEGXL_QUALITY = 640;
    public static final int IMWRITE_JPEGXL_EFFORT = 641;
    public static final int IMWRITE_JPEGXL_DISTANCE = 642;
    public static final int IMWRITE_JPEGXL_DECODING_SPEED = 643;
    public static final int IMWRITE_GIF_LOOP = 1024;
    public static final int IMWRITE_GIF_SPEED = 1025;
    public static final int IMWRITE_GIF_QUALITY = 1026;
    public static final int IMWRITE_GIF_DITHER = 1027;
    public static final int IMWRITE_GIF_TRANSPARENCY = 1028;
    public static final int IMWRITE_GIF_COLORTABLE = 1029;
    public static final int IMWRITE_GIF_FAST_NO_DITHER = 1;
    public static final int IMWRITE_GIF_FAST_FLOYD_DITHER = 2;
    public static final int IMWRITE_GIF_COLORTABLE_SIZE_8 = 3;
    public static final int IMWRITE_GIF_COLORTABLE_SIZE_16 = 4;
    public static final int IMWRITE_GIF_COLORTABLE_SIZE_32 = 5;
    public static final int IMWRITE_GIF_COLORTABLE_SIZE_64 = 6;
    public static final int IMWRITE_GIF_COLORTABLE_SIZE_128 = 7;
    public static final int IMWRITE_GIF_COLORTABLE_SIZE_256 = 8;
    public static final int IMWRITE_HDR_COMPRESSION_NONE = 0;
    public static final int IMWRITE_HDR_COMPRESSION_RLE = 1;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR_411 = 0x411111;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR_420 = 0x221111;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR_422 = 0x211111;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR_440 = 0x121111;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR_444 = 0x111111;
    public static final int IMWRITE_PAM_FORMAT_NULL = 0;
    public static final int IMWRITE_PAM_FORMAT_BLACKANDWHITE = 1;
    public static final int IMWRITE_PAM_FORMAT_GRAYSCALE = 2;
    public static final int IMWRITE_PAM_FORMAT_GRAYSCALE_ALPHA = 3;
    public static final int IMWRITE_PAM_FORMAT_RGB = 4;
    public static final int IMWRITE_PAM_FORMAT_RGB_ALPHA = 5;
    public static final int IMWRITE_PNG_FILTER_NONE = 8;
    public static final int IMWRITE_PNG_FILTER_SUB = 16;
    public static final int IMWRITE_PNG_FILTER_UP = 32;
    public static final int IMWRITE_PNG_FILTER_AVG = 64;
    public static final int IMWRITE_PNG_FILTER_PAETH = 128;
    public static final int IMWRITE_PNG_FAST_FILTERS = 56;
    public static final int IMWRITE_PNG_ALL_FILTERS = 248;
    public static final int IMWRITE_PNG_STRATEGY_DEFAULT = 0;
    public static final int IMWRITE_PNG_STRATEGY_FILTERED = 1;
    public static final int IMWRITE_PNG_STRATEGY_HUFFMAN_ONLY = 2;
    public static final int IMWRITE_PNG_STRATEGY_RLE = 3;
    public static final int IMWRITE_PNG_STRATEGY_FIXED = 4;
    public static final int IMWRITE_TIFF_COMPRESSION_NONE = 1;
    public static final int IMWRITE_TIFF_COMPRESSION_CCITTRLE = 2;
    public static final int IMWRITE_TIFF_COMPRESSION_CCITTFAX3 = 3;
    public static final int IMWRITE_TIFF_COMPRESSION_CCITT_T4 = 3;
    public static final int IMWRITE_TIFF_COMPRESSION_CCITTFAX4 = 4;
    public static final int IMWRITE_TIFF_COMPRESSION_CCITT_T6 = 4;
    public static final int IMWRITE_TIFF_COMPRESSION_LZW = 5;
    public static final int IMWRITE_TIFF_COMPRESSION_OJPEG = 6;
    public static final int IMWRITE_TIFF_COMPRESSION_JPEG = 7;
    public static final int IMWRITE_TIFF_COMPRESSION_T85 = 9;
    public static final int IMWRITE_TIFF_COMPRESSION_T43 = 10;
    public static final int IMWRITE_TIFF_COMPRESSION_NEXT = 32766;
    public static final int IMWRITE_TIFF_COMPRESSION_CCITTRLEW = 32771;
    public static final int IMWRITE_TIFF_COMPRESSION_PACKBITS = 32773;
    public static final int IMWRITE_TIFF_COMPRESSION_THUNDERSCAN = 32809;
    public static final int IMWRITE_TIFF_COMPRESSION_IT8CTPAD = 32895;
    public static final int IMWRITE_TIFF_COMPRESSION_IT8LW = 32896;
    public static final int IMWRITE_TIFF_COMPRESSION_IT8MP = 32897;
    public static final int IMWRITE_TIFF_COMPRESSION_IT8BL = 32898;
    public static final int IMWRITE_TIFF_COMPRESSION_PIXARFILM = 32908;
    public static final int IMWRITE_TIFF_COMPRESSION_PIXARLOG = 32909;
    public static final int IMWRITE_TIFF_COMPRESSION_DEFLATE = 32946;
    public static final int IMWRITE_TIFF_COMPRESSION_ADOBE_DEFLATE = 8;
    public static final int IMWRITE_TIFF_COMPRESSION_DCS = 32947;
    public static final int IMWRITE_TIFF_COMPRESSION_JBIG = 34661;
    public static final int IMWRITE_TIFF_COMPRESSION_SGILOG = 34676;
    public static final int IMWRITE_TIFF_COMPRESSION_SGILOG24 = 34677;
    public static final int IMWRITE_TIFF_COMPRESSION_JP2000 = 34712;
    public static final int IMWRITE_TIFF_COMPRESSION_LERC = 34887;
    public static final int IMWRITE_TIFF_COMPRESSION_LZMA = 34925;
    public static final int IMWRITE_TIFF_COMPRESSION_ZSTD = 50000;
    public static final int IMWRITE_TIFF_COMPRESSION_WEBP = 50001;
    public static final int IMWRITE_TIFF_COMPRESSION_JXL = 50002;
    public static final int IMWRITE_TIFF_PREDICTOR_NONE = 1;
    public static final int IMWRITE_TIFF_PREDICTOR_HORIZONTAL = 2;
    public static final int IMWRITE_TIFF_PREDICTOR_FLOATINGPOINT = 3;

    public static Mat imread(String filename, int flags) {
        return new Mat(Imgcodecs.imread_0(filename, flags));
    }

    public static Mat imread(String filename) {
        return new Mat(Imgcodecs.imread_1(filename));
    }

    public static void imread(String filename, Mat dst, int flags) {
        Imgcodecs.imread_2(filename, dst.nativeObj, flags);
    }

    public static void imread(String filename, Mat dst) {
        Imgcodecs.imread_3(filename, dst.nativeObj);
    }

    public static Mat imreadWithMetadata(String filename, MatOfInt metadataTypes, List<Mat> metadata, int flags) {
        MatOfInt metadataTypes_mat = metadataTypes;
        Mat metadata_mat = new Mat();
        Mat retVal = new Mat(Imgcodecs.imreadWithMetadata_0(filename, metadataTypes_mat.nativeObj, metadata_mat.nativeObj, flags));
        Converters.Mat_to_vector_Mat(metadata_mat, metadata);
        metadata_mat.release();
        return retVal;
    }

    public static Mat imreadWithMetadata(String filename, MatOfInt metadataTypes, List<Mat> metadata) {
        MatOfInt metadataTypes_mat = metadataTypes;
        Mat metadata_mat = new Mat();
        Mat retVal = new Mat(Imgcodecs.imreadWithMetadata_1(filename, metadataTypes_mat.nativeObj, metadata_mat.nativeObj));
        Converters.Mat_to_vector_Mat(metadata_mat, metadata);
        metadata_mat.release();
        return retVal;
    }

    public static boolean imreadmulti(String filename, List<Mat> mats, int flags) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imreadmulti_0(filename, mats_mat.nativeObj, flags);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imreadmulti(String filename, List<Mat> mats) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imreadmulti_1(filename, mats_mat.nativeObj);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imreadmulti(String filename, List<Mat> mats, int start, int count, int flags) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imreadmulti_2(filename, mats_mat.nativeObj, start, count, flags);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imreadmulti(String filename, List<Mat> mats, int start, int count) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imreadmulti_3(filename, mats_mat.nativeObj, start, count);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imreadanimation(String filename, Animation animation, int start, int count) {
        return Imgcodecs.imreadanimation_0(filename, animation.getNativeObjAddr(), start, count);
    }

    public static boolean imreadanimation(String filename, Animation animation, int start) {
        return Imgcodecs.imreadanimation_1(filename, animation.getNativeObjAddr(), start);
    }

    public static boolean imreadanimation(String filename, Animation animation) {
        return Imgcodecs.imreadanimation_2(filename, animation.getNativeObjAddr());
    }

    public static boolean imdecodeanimation(Mat buf, Animation animation, int start, int count) {
        return Imgcodecs.imdecodeanimation_0(buf.nativeObj, animation.getNativeObjAddr(), start, count);
    }

    public static boolean imdecodeanimation(Mat buf, Animation animation, int start) {
        return Imgcodecs.imdecodeanimation_1(buf.nativeObj, animation.getNativeObjAddr(), start);
    }

    public static boolean imdecodeanimation(Mat buf, Animation animation) {
        return Imgcodecs.imdecodeanimation_2(buf.nativeObj, animation.getNativeObjAddr());
    }

    public static boolean imwriteanimation(String filename, Animation animation, MatOfInt params) {
        MatOfInt params_mat = params;
        return Imgcodecs.imwriteanimation_0(filename, animation.getNativeObjAddr(), params_mat.nativeObj);
    }

    public static boolean imwriteanimation(String filename, Animation animation) {
        return Imgcodecs.imwriteanimation_1(filename, animation.getNativeObjAddr());
    }

    public static boolean imencodeanimation(String ext, Animation animation, MatOfByte buf, MatOfInt params) {
        MatOfByte buf_mat = buf;
        MatOfInt params_mat = params;
        return Imgcodecs.imencodeanimation_0(ext, animation.getNativeObjAddr(), buf_mat.nativeObj, params_mat.nativeObj);
    }

    public static boolean imencodeanimation(String ext, Animation animation, MatOfByte buf) {
        MatOfByte buf_mat = buf;
        return Imgcodecs.imencodeanimation_1(ext, animation.getNativeObjAddr(), buf_mat.nativeObj);
    }

    public static long imcount(String filename, int flags) {
        return Imgcodecs.imcount_0(filename, flags);
    }

    public static long imcount(String filename) {
        return Imgcodecs.imcount_1(filename);
    }

    public static boolean imwrite(String filename, Mat img, MatOfInt params) {
        MatOfInt params_mat = params;
        return Imgcodecs.imwrite_0(filename, img.nativeObj, params_mat.nativeObj);
    }

    public static boolean imwrite(String filename, Mat img) {
        return Imgcodecs.imwrite_1(filename, img.nativeObj);
    }

    public static boolean imwriteWithMetadata(String filename, Mat img, MatOfInt metadataTypes, List<Mat> metadata, MatOfInt params) {
        MatOfInt metadataTypes_mat = metadataTypes;
        Mat metadata_mat = Converters.vector_Mat_to_Mat(metadata);
        MatOfInt params_mat = params;
        return Imgcodecs.imwriteWithMetadata_0(filename, img.nativeObj, metadataTypes_mat.nativeObj, metadata_mat.nativeObj, params_mat.nativeObj);
    }

    public static boolean imwriteWithMetadata(String filename, Mat img, MatOfInt metadataTypes, List<Mat> metadata) {
        MatOfInt metadataTypes_mat = metadataTypes;
        Mat metadata_mat = Converters.vector_Mat_to_Mat(metadata);
        return Imgcodecs.imwriteWithMetadata_1(filename, img.nativeObj, metadataTypes_mat.nativeObj, metadata_mat.nativeObj);
    }

    public static boolean imwritemulti(String filename, List<Mat> img, MatOfInt params) {
        Mat img_mat = Converters.vector_Mat_to_Mat(img);
        MatOfInt params_mat = params;
        return Imgcodecs.imwritemulti_0(filename, img_mat.nativeObj, params_mat.nativeObj);
    }

    public static boolean imwritemulti(String filename, List<Mat> img) {
        Mat img_mat = Converters.vector_Mat_to_Mat(img);
        return Imgcodecs.imwritemulti_1(filename, img_mat.nativeObj);
    }

    public static Mat imdecode(Mat buf, int flags) {
        return new Mat(Imgcodecs.imdecode_0(buf.nativeObj, flags));
    }

    public static Mat imdecodeWithMetadata(Mat buf, MatOfInt metadataTypes, List<Mat> metadata, int flags) {
        MatOfInt metadataTypes_mat = metadataTypes;
        Mat metadata_mat = new Mat();
        Mat retVal = new Mat(Imgcodecs.imdecodeWithMetadata_0(buf.nativeObj, metadataTypes_mat.nativeObj, metadata_mat.nativeObj, flags));
        Converters.Mat_to_vector_Mat(metadata_mat, metadata);
        metadata_mat.release();
        return retVal;
    }

    public static Mat imdecodeWithMetadata(Mat buf, MatOfInt metadataTypes, List<Mat> metadata) {
        MatOfInt metadataTypes_mat = metadataTypes;
        Mat metadata_mat = new Mat();
        Mat retVal = new Mat(Imgcodecs.imdecodeWithMetadata_1(buf.nativeObj, metadataTypes_mat.nativeObj, metadata_mat.nativeObj));
        Converters.Mat_to_vector_Mat(metadata_mat, metadata);
        metadata_mat.release();
        return retVal;
    }

    public static boolean imdecodemulti(Mat buf, int flags, List<Mat> mats, Range range) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imdecodemulti_0(buf.nativeObj, flags, mats_mat.nativeObj, range.start, range.end);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imdecodemulti(Mat buf, int flags, List<Mat> mats) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imdecodemulti_1(buf.nativeObj, flags, mats_mat.nativeObj);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imencode(String ext, Mat img, MatOfByte buf, MatOfInt params) {
        MatOfByte buf_mat = buf;
        MatOfInt params_mat = params;
        return Imgcodecs.imencode_0(ext, img.nativeObj, buf_mat.nativeObj, params_mat.nativeObj);
    }

    public static boolean imencode(String ext, Mat img, MatOfByte buf) {
        MatOfByte buf_mat = buf;
        return Imgcodecs.imencode_1(ext, img.nativeObj, buf_mat.nativeObj);
    }

    public static boolean imencodeWithMetadata(String ext, Mat img, MatOfInt metadataTypes, List<Mat> metadata, MatOfByte buf, MatOfInt params) {
        MatOfInt metadataTypes_mat = metadataTypes;
        Mat metadata_mat = Converters.vector_Mat_to_Mat(metadata);
        MatOfByte buf_mat = buf;
        MatOfInt params_mat = params;
        return Imgcodecs.imencodeWithMetadata_0(ext, img.nativeObj, metadataTypes_mat.nativeObj, metadata_mat.nativeObj, buf_mat.nativeObj, params_mat.nativeObj);
    }

    public static boolean imencodeWithMetadata(String ext, Mat img, MatOfInt metadataTypes, List<Mat> metadata, MatOfByte buf) {
        MatOfInt metadataTypes_mat = metadataTypes;
        Mat metadata_mat = Converters.vector_Mat_to_Mat(metadata);
        MatOfByte buf_mat = buf;
        return Imgcodecs.imencodeWithMetadata_1(ext, img.nativeObj, metadataTypes_mat.nativeObj, metadata_mat.nativeObj, buf_mat.nativeObj);
    }

    public static boolean imencodemulti(String ext, List<Mat> imgs, MatOfByte buf, MatOfInt params) {
        Mat imgs_mat = Converters.vector_Mat_to_Mat(imgs);
        MatOfByte buf_mat = buf;
        MatOfInt params_mat = params;
        return Imgcodecs.imencodemulti_0(ext, imgs_mat.nativeObj, buf_mat.nativeObj, params_mat.nativeObj);
    }

    public static boolean imencodemulti(String ext, List<Mat> imgs, MatOfByte buf) {
        Mat imgs_mat = Converters.vector_Mat_to_Mat(imgs);
        MatOfByte buf_mat = buf;
        return Imgcodecs.imencodemulti_1(ext, imgs_mat.nativeObj, buf_mat.nativeObj);
    }

    public static boolean haveImageReader(String filename) {
        return Imgcodecs.haveImageReader_0(filename);
    }

    public static boolean haveImageWriter(String filename) {
        return Imgcodecs.haveImageWriter_0(filename);
    }

    private static native long imread_0(String var0, int var1);

    private static native long imread_1(String var0);

    private static native void imread_2(String var0, long var1, int var3);

    private static native void imread_3(String var0, long var1);

    private static native long imreadWithMetadata_0(String var0, long var1, long var3, int var5);

    private static native long imreadWithMetadata_1(String var0, long var1, long var3);

    private static native boolean imreadmulti_0(String var0, long var1, int var3);

    private static native boolean imreadmulti_1(String var0, long var1);

    private static native boolean imreadmulti_2(String var0, long var1, int var3, int var4, int var5);

    private static native boolean imreadmulti_3(String var0, long var1, int var3, int var4);

    private static native boolean imreadanimation_0(String var0, long var1, int var3, int var4);

    private static native boolean imreadanimation_1(String var0, long var1, int var3);

    private static native boolean imreadanimation_2(String var0, long var1);

    private static native boolean imdecodeanimation_0(long var0, long var2, int var4, int var5);

    private static native boolean imdecodeanimation_1(long var0, long var2, int var4);

    private static native boolean imdecodeanimation_2(long var0, long var2);

    private static native boolean imwriteanimation_0(String var0, long var1, long var3);

    private static native boolean imwriteanimation_1(String var0, long var1);

    private static native boolean imencodeanimation_0(String var0, long var1, long var3, long var5);

    private static native boolean imencodeanimation_1(String var0, long var1, long var3);

    private static native long imcount_0(String var0, int var1);

    private static native long imcount_1(String var0);

    private static native boolean imwrite_0(String var0, long var1, long var3);

    private static native boolean imwrite_1(String var0, long var1);

    private static native boolean imwriteWithMetadata_0(String var0, long var1, long var3, long var5, long var7);

    private static native boolean imwriteWithMetadata_1(String var0, long var1, long var3, long var5);

    private static native boolean imwritemulti_0(String var0, long var1, long var3);

    private static native boolean imwritemulti_1(String var0, long var1);

    private static native long imdecode_0(long var0, int var2);

    private static native long imdecodeWithMetadata_0(long var0, long var2, long var4, int var6);

    private static native long imdecodeWithMetadata_1(long var0, long var2, long var4);

    private static native boolean imdecodemulti_0(long var0, int var2, long var3, int var5, int var6);

    private static native boolean imdecodemulti_1(long var0, int var2, long var3);

    private static native boolean imencode_0(String var0, long var1, long var3, long var5);

    private static native boolean imencode_1(String var0, long var1, long var3);

    private static native boolean imencodeWithMetadata_0(String var0, long var1, long var3, long var5, long var7, long var9);

    private static native boolean imencodeWithMetadata_1(String var0, long var1, long var3, long var5, long var7);

    private static native boolean imencodemulti_0(String var0, long var1, long var3, long var5);

    private static native boolean imencodemulti_1(String var0, long var1, long var3);

    private static native boolean haveImageReader_0(String var0);

    private static native boolean haveImageWriter_0(String var0);
}

