/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.annotation.TargetApi;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.util.List;
import org.opencv.android.CameraGLRendererBase;
import org.opencv.android.CameraGLSurfaceView;

@TargetApi(value=15)
public class CameraRenderer
extends CameraGLRendererBase {
    public static final String LOGTAG = "CameraRenderer";
    private Camera mCamera;
    private boolean mPreviewStarted = false;

    CameraRenderer(CameraGLSurfaceView view) {
        super(view);
    }

    @Override
    protected synchronized void closeCamera() {
        Log.i((String)LOGTAG, (String)"closeCamera");
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.mPreviewStarted = false;
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    @Override
    protected synchronized void openCamera(int id) {
        Log.i((String)LOGTAG, (String)"openCamera");
        this.closeCamera();
        if (id == -1) {
            Log.d((String)LOGTAG, (String)"Trying to open camera with old open()");
            try {
                this.mCamera = Camera.open();
            }
            catch (Exception e) {
                Log.e((String)LOGTAG, (String)("Camera is not available (in use or does not exist): " + e.getLocalizedMessage()));
            }
            if (this.mCamera == null && Build.VERSION.SDK_INT >= 9) {
                boolean connected = false;
                for (int camIdx = 0; camIdx < Camera.getNumberOfCameras(); ++camIdx) {
                    Log.d((String)LOGTAG, (String)("Trying to open camera with new open(" + camIdx + ")"));
                    try {
                        this.mCamera = Camera.open((int)camIdx);
                        connected = true;
                    }
                    catch (RuntimeException e) {
                        Log.e((String)LOGTAG, (String)("Camera #" + camIdx + "failed to open: " + e.getLocalizedMessage()));
                    }
                    if (!connected) {
                        continue;
                    }
                    break;
                }
            }
        } else if (Build.VERSION.SDK_INT >= 9) {
            int localCameraIndex = this.mCameraIndex;
            if (this.mCameraIndex == 99) {
                Log.i((String)LOGTAG, (String)"Trying to open BACK camera");
                cameraInfo = new Camera.CameraInfo();
                for (camIdx = 0; camIdx < Camera.getNumberOfCameras(); ++camIdx) {
                    Camera.getCameraInfo((int)camIdx, (Camera.CameraInfo)cameraInfo);
                    if (cameraInfo.facing != 0) continue;
                    localCameraIndex = camIdx;
                    break;
                }
            } else if (this.mCameraIndex == 98) {
                Log.i((String)LOGTAG, (String)"Trying to open FRONT camera");
                cameraInfo = new Camera.CameraInfo();
                for (camIdx = 0; camIdx < Camera.getNumberOfCameras(); ++camIdx) {
                    Camera.getCameraInfo((int)camIdx, (Camera.CameraInfo)cameraInfo);
                    if (cameraInfo.facing != 1) continue;
                    localCameraIndex = camIdx;
                    break;
                }
            }
            if (localCameraIndex == 99) {
                Log.e((String)LOGTAG, (String)"Back camera not found!");
            } else if (localCameraIndex == 98) {
                Log.e((String)LOGTAG, (String)"Front camera not found!");
            } else {
                Log.d((String)LOGTAG, (String)("Trying to open camera with new open(" + localCameraIndex + ")"));
                try {
                    this.mCamera = Camera.open((int)localCameraIndex);
                }
                catch (RuntimeException e) {
                    Log.e((String)LOGTAG, (String)("Camera #" + localCameraIndex + "failed to open: " + e.getLocalizedMessage()));
                }
            }
        }
        if (this.mCamera == null) {
            Log.e((String)LOGTAG, (String)"Error: can't open camera");
            return;
        }
        Camera.Parameters params = this.mCamera.getParameters();
        List FocusModes = params.getSupportedFocusModes();
        if (FocusModes != null && FocusModes.contains("continuous-video")) {
            params.setFocusMode("continuous-video");
        }
        this.mCamera.setParameters(params);
        try {
            this.mCamera.setPreviewTexture(this.mSTexture);
        }
        catch (IOException ioe) {
            Log.e((String)LOGTAG, (String)("setPreviewTexture() failed: " + ioe.getMessage()));
        }
    }

    @Override
    public synchronized void setCameraPreviewSize(int width, int height) {
        Log.i((String)LOGTAG, (String)("setCameraPreviewSize: " + width + "x" + height));
        if (this.mCamera == null) {
            Log.e((String)LOGTAG, (String)"Camera isn't initialized!");
            return;
        }
        if (this.mMaxCameraWidth > 0 && this.mMaxCameraWidth < width) {
            width = this.mMaxCameraWidth;
        }
        if (this.mMaxCameraHeight > 0 && this.mMaxCameraHeight < height) {
            height = this.mMaxCameraHeight;
        }
        Camera.Parameters param = this.mCamera.getParameters();
        List psize = param.getSupportedPreviewSizes();
        int bestWidth = 0;
        int bestHeight = 0;
        if (psize.size() > 0) {
            float aspect = (float)width / (float)height;
            for (Camera.Size size : psize) {
                int w = size.width;
                int h = size.height;
                Log.d((String)LOGTAG, (String)("checking camera preview size: " + w + "x" + h));
                if (w > width || h > height || w < bestWidth || h < bestHeight || !((double)Math.abs(aspect - (float)w / (float)h) < 0.2)) continue;
                bestWidth = w;
                bestHeight = h;
            }
            if (bestWidth <= 0 || bestHeight <= 0) {
                bestWidth = ((Camera.Size)psize.get((int)0)).width;
                bestHeight = ((Camera.Size)psize.get((int)0)).height;
                Log.e((String)LOGTAG, (String)("Error: best size was not selected, using " + bestWidth + " x " + bestHeight));
            } else {
                Log.i((String)LOGTAG, (String)("Selected best size: " + bestWidth + " x " + bestHeight));
            }
            if (this.mPreviewStarted) {
                this.mCamera.stopPreview();
                this.mPreviewStarted = false;
            }
            this.mCameraWidth = bestWidth;
            this.mCameraHeight = bestHeight;
            param.setPreviewSize(bestWidth, bestHeight);
        }
        param.set("orientation", "landscape");
        this.mCamera.setParameters(param);
        this.mCamera.startPreview();
        this.mPreviewStarted = true;
    }
}

