/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.objdetect.CharucoBoard;
import org.opencv.objdetect.CharucoParameters;
import org.opencv.objdetect.DetectorParameters;
import org.opencv.objdetect.RefineParameters;
import org.opencv.utils.Converters;

public class CharucoDetector
extends Algorithm {
    protected CharucoDetector(long addr) {
        super(addr);
    }

    public static CharucoDetector __fromPtr__(long addr) {
        return new CharucoDetector(addr);
    }

    public CharucoDetector(CharucoBoard board, CharucoParameters charucoParams, DetectorParameters detectorParams, RefineParameters refineParams) {
        super(CharucoDetector.CharucoDetector_0(board.getNativeObjAddr(), charucoParams.getNativeObjAddr(), detectorParams.getNativeObjAddr(), refineParams.getNativeObjAddr()));
    }

    public CharucoDetector(CharucoBoard board, CharucoParameters charucoParams, DetectorParameters detectorParams) {
        super(CharucoDetector.CharucoDetector_1(board.getNativeObjAddr(), charucoParams.getNativeObjAddr(), detectorParams.getNativeObjAddr()));
    }

    public CharucoDetector(CharucoBoard board, CharucoParameters charucoParams) {
        super(CharucoDetector.CharucoDetector_2(board.getNativeObjAddr(), charucoParams.getNativeObjAddr()));
    }

    public CharucoDetector(CharucoBoard board) {
        super(CharucoDetector.CharucoDetector_3(board.getNativeObjAddr()));
    }

    public CharucoBoard getBoard() {
        return new CharucoBoard(CharucoDetector.getBoard_0(this.nativeObj));
    }

    public void setBoard(CharucoBoard board) {
        CharucoDetector.setBoard_0(this.nativeObj, board.getNativeObjAddr());
    }

    public CharucoParameters getCharucoParameters() {
        return new CharucoParameters(CharucoDetector.getCharucoParameters_0(this.nativeObj));
    }

    public void setCharucoParameters(CharucoParameters charucoParameters) {
        CharucoDetector.setCharucoParameters_0(this.nativeObj, charucoParameters.getNativeObjAddr());
    }

    public DetectorParameters getDetectorParameters() {
        return new DetectorParameters(CharucoDetector.getDetectorParameters_0(this.nativeObj));
    }

    public void setDetectorParameters(DetectorParameters detectorParameters) {
        CharucoDetector.setDetectorParameters_0(this.nativeObj, detectorParameters.getNativeObjAddr());
    }

    public RefineParameters getRefineParameters() {
        return new RefineParameters(CharucoDetector.getRefineParameters_0(this.nativeObj));
    }

    public void setRefineParameters(RefineParameters refineParameters) {
        CharucoDetector.setRefineParameters_0(this.nativeObj, refineParameters.getNativeObjAddr());
    }

    public void detectBoard(Mat image, Mat charucoCorners, Mat charucoIds, List<Mat> markerCorners, Mat markerIds) {
        Mat markerCorners_mat = Converters.vector_Mat_to_Mat(markerCorners);
        CharucoDetector.detectBoard_0(this.nativeObj, image.nativeObj, charucoCorners.nativeObj, charucoIds.nativeObj, markerCorners_mat.nativeObj, markerIds.nativeObj);
        Converters.Mat_to_vector_Mat(markerCorners_mat, markerCorners);
        markerCorners_mat.release();
    }

    public void detectBoard(Mat image, Mat charucoCorners, Mat charucoIds, List<Mat> markerCorners) {
        Mat markerCorners_mat = Converters.vector_Mat_to_Mat(markerCorners);
        CharucoDetector.detectBoard_1(this.nativeObj, image.nativeObj, charucoCorners.nativeObj, charucoIds.nativeObj, markerCorners_mat.nativeObj);
        Converters.Mat_to_vector_Mat(markerCorners_mat, markerCorners);
        markerCorners_mat.release();
    }

    public void detectBoard(Mat image, Mat charucoCorners, Mat charucoIds) {
        CharucoDetector.detectBoard_2(this.nativeObj, image.nativeObj, charucoCorners.nativeObj, charucoIds.nativeObj);
    }

    public void detectDiamonds(Mat image, List<Mat> diamondCorners, Mat diamondIds, List<Mat> markerCorners, Mat markerIds) {
        Mat diamondCorners_mat = new Mat();
        Mat markerCorners_mat = Converters.vector_Mat_to_Mat(markerCorners);
        CharucoDetector.detectDiamonds_0(this.nativeObj, image.nativeObj, diamondCorners_mat.nativeObj, diamondIds.nativeObj, markerCorners_mat.nativeObj, markerIds.nativeObj);
        Converters.Mat_to_vector_Mat(diamondCorners_mat, diamondCorners);
        diamondCorners_mat.release();
        Converters.Mat_to_vector_Mat(markerCorners_mat, markerCorners);
        markerCorners_mat.release();
    }

    public void detectDiamonds(Mat image, List<Mat> diamondCorners, Mat diamondIds, List<Mat> markerCorners) {
        Mat diamondCorners_mat = new Mat();
        Mat markerCorners_mat = Converters.vector_Mat_to_Mat(markerCorners);
        CharucoDetector.detectDiamonds_1(this.nativeObj, image.nativeObj, diamondCorners_mat.nativeObj, diamondIds.nativeObj, markerCorners_mat.nativeObj);
        Converters.Mat_to_vector_Mat(diamondCorners_mat, diamondCorners);
        diamondCorners_mat.release();
        Converters.Mat_to_vector_Mat(markerCorners_mat, markerCorners);
        markerCorners_mat.release();
    }

    public void detectDiamonds(Mat image, List<Mat> diamondCorners, Mat diamondIds) {
        Mat diamondCorners_mat = new Mat();
        CharucoDetector.detectDiamonds_2(this.nativeObj, image.nativeObj, diamondCorners_mat.nativeObj, diamondIds.nativeObj);
        Converters.Mat_to_vector_Mat(diamondCorners_mat, diamondCorners);
        diamondCorners_mat.release();
    }

    @Override
    protected void finalize() throws Throwable {
        CharucoDetector.delete(this.nativeObj);
    }

    private static native long CharucoDetector_0(long var0, long var2, long var4, long var6);

    private static native long CharucoDetector_1(long var0, long var2, long var4);

    private static native long CharucoDetector_2(long var0, long var2);

    private static native long CharucoDetector_3(long var0);

    private static native long getBoard_0(long var0);

    private static native void setBoard_0(long var0, long var2);

    private static native long getCharucoParameters_0(long var0);

    private static native void setCharucoParameters_0(long var0, long var2);

    private static native long getDetectorParameters_0(long var0);

    private static native void setDetectorParameters_0(long var0, long var2);

    private static native long getRefineParameters_0(long var0);

    private static native void setRefineParameters_0(long var0, long var2);

    private static native void detectBoard_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void detectBoard_1(long var0, long var2, long var4, long var6, long var8);

    private static native void detectBoard_2(long var0, long var2, long var4, long var6);

    private static native void detectDiamonds_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void detectDiamonds_1(long var0, long var2, long var4, long var6, long var8);

    private static native void detectDiamonds_2(long var0, long var2, long var4, long var6);

    private static native void delete(long var0);
}

