/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint3f;
import org.opencv.core.Point3;
import org.opencv.core.Size;
import org.opencv.objdetect.Dictionary;
import org.opencv.utils.Converters;

public class Board {
    protected final long nativeObj;

    protected Board(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Board __fromPtr__(long addr) {
        return new Board(addr);
    }

    public Board(List<Mat> objPoints, Dictionary dictionary, Mat ids) {
        Mat objPoints_mat = Converters.vector_Mat_to_Mat(objPoints);
        this.nativeObj = Board.Board_0(objPoints_mat.nativeObj, dictionary.getNativeObjAddr(), ids.nativeObj);
    }

    public Dictionary getDictionary() {
        return new Dictionary(Board.getDictionary_0(this.nativeObj));
    }

    public List<MatOfPoint3f> getObjPoints() {
        ArrayList<MatOfPoint3f> retVal = new ArrayList<MatOfPoint3f>();
        Mat retValMat = new Mat(Board.getObjPoints_0(this.nativeObj));
        Converters.Mat_to_vector_vector_Point3f(retValMat, retVal);
        return retVal;
    }

    public MatOfInt getIds() {
        return MatOfInt.fromNativeAddr(Board.getIds_0(this.nativeObj));
    }

    public Point3 getRightBottomCorner() {
        return new Point3(Board.getRightBottomCorner_0(this.nativeObj));
    }

    public void matchImagePoints(List<Mat> detectedCorners, Mat detectedIds, Mat objPoints, Mat imgPoints) {
        Mat detectedCorners_mat = Converters.vector_Mat_to_Mat(detectedCorners);
        Board.matchImagePoints_0(this.nativeObj, detectedCorners_mat.nativeObj, detectedIds.nativeObj, objPoints.nativeObj, imgPoints.nativeObj);
    }

    public void generateImage(Size outSize, Mat img, int marginSize, int borderBits) {
        Board.generateImage_0(this.nativeObj, outSize.width, outSize.height, img.nativeObj, marginSize, borderBits);
    }

    public void generateImage(Size outSize, Mat img, int marginSize) {
        Board.generateImage_1(this.nativeObj, outSize.width, outSize.height, img.nativeObj, marginSize);
    }

    public void generateImage(Size outSize, Mat img) {
        Board.generateImage_2(this.nativeObj, outSize.width, outSize.height, img.nativeObj);
    }

    protected void finalize() throws Throwable {
        Board.delete(this.nativeObj);
    }

    private static native long Board_0(long var0, long var2, long var4);

    private static native long getDictionary_0(long var0);

    private static native long getObjPoints_0(long var0);

    private static native long getIds_0(long var0);

    private static native double[] getRightBottomCorner_0(long var0);

    private static native void matchImagePoints_0(long var0, long var2, long var4, long var6, long var8);

    private static native void generateImage_0(long var0, double var2, double var4, long var6, int var8, int var9);

    private static native void generateImage_1(long var0, double var2, double var4, long var6, int var8);

    private static native void generateImage_2(long var0, double var2, double var4, long var6);

    private static native void delete(long var0);
}

