/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.util.Log;
import org.opencv.core.Core;

class StaticHelper {
    private static final String TAG = "OpenCV/StaticHelper";

    StaticHelper() {
    }

    public static boolean initOpenCV(boolean InitCuda) {
        boolean result;
        String libs = "";
        if (InitCuda) {
            Log.w((String)TAG, (String)"CUDA support was removed!");
        }
        Log.d((String)TAG, (String)"First attempt to load libs");
        if (StaticHelper.loadLibrary("opencv_java4")) {
            Log.d((String)TAG, (String)"First attempt to load libs is OK");
            String eol = System.getProperty("line.separator");
            for (String str : Core.getBuildInformation().split(eol)) {
                Log.i((String)TAG, (String)str);
            }
            result = true;
        } else {
            Log.d((String)TAG, (String)"First attempt to load libs fails");
            result = false;
        }
        return result;
    }

    private static boolean loadLibrary(String Name) {
        boolean result = true;
        Log.d((String)TAG, (String)("Trying to load library " + Name));
        try {
            System.loadLibrary(Name);
            Log.d((String)TAG, (String)("Library " + Name + " loaded"));
        }
        catch (UnsatisfiedLinkError e) {
            Log.d((String)TAG, (String)("Cannot load library \"" + Name + "\""));
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private static native String getLibraryList();
}

