/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.util.Log;
import org.opencv.android.CameraBridgeViewBase;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.Size;
import org.opencv.videoio.VideoCapture;
import org.opencv.videoio.VideoWriter;

public class NativeCameraView
extends CameraBridgeViewBase {
    public static final String TAG = "NativeCameraView";
    private boolean mStopThread;
    private Thread mThread;
    protected VideoCapture mCamera;
    protected CameraBridgeViewBase.RotatedCameraFrame mFrame;

    public NativeCameraView(Context context, int cameraId) {
        super(context, cameraId);
    }

    public NativeCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected boolean connectCamera(int width, int height) {
        if (!this.initializeCamera(width, height)) {
            return false;
        }
        this.mThread = new Thread(new CameraWorker());
        this.mThread.start();
        return true;
    }

    @Override
    protected void disconnectCamera() {
        if (this.mThread != null) {
            try {
                this.mStopThread = true;
                this.mThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.mThread = null;
                this.mStopThread = false;
            }
        }
        this.releaseCamera();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeCamera(int width, int height) {
        NativeCameraView nativeCameraView = this;
        synchronized (nativeCameraView) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            int localCameraIndex = this.mCameraIndex;
            if (this.mCameraIndex == -1) {
                Log.d((String)TAG, (String)"Try to open default camera");
                localCameraIndex = 0;
            } else if (this.mCameraIndex == 99) {
                Log.i((String)TAG, (String)"Trying to open back camera");
                for (camIdx = 0; camIdx < Camera.getNumberOfCameras(); ++camIdx) {
                    Camera.getCameraInfo((int)camIdx, (Camera.CameraInfo)cameraInfo);
                    if (cameraInfo.facing != 0) continue;
                    localCameraIndex = camIdx;
                    break;
                }
            } else if (this.mCameraIndex == 98) {
                Log.i((String)TAG, (String)"Trying to open front camera");
                for (camIdx = 0; camIdx < Camera.getNumberOfCameras(); ++camIdx) {
                    Camera.getCameraInfo((int)camIdx, (Camera.CameraInfo)cameraInfo);
                    if (cameraInfo.facing != 1) continue;
                    localCameraIndex = camIdx;
                    break;
                }
            }
            if (localCameraIndex == 99) {
                Log.e((String)TAG, (String)"Back camera not found!");
                return false;
            }
            if (localCameraIndex == 98) {
                Log.e((String)TAG, (String)"Front camera not found!");
                return false;
            }
            MatOfInt params = new MatOfInt(3, width, 4, height);
            Log.d((String)TAG, (String)("Try to open camera with index " + localCameraIndex));
            this.mCamera = new VideoCapture(localCameraIndex, 1000, params);
            if (this.mCamera == null) {
                return false;
            }
            if (!this.mCamera.isOpened()) {
                return false;
            }
            if (this.mCameraIndex != 99 && this.mCameraIndex != 98) {
                Camera.getCameraInfo((int)localCameraIndex, (Camera.CameraInfo)cameraInfo);
            }
            int frameRotation = this.getFrameRotation(cameraInfo.facing == 1, cameraInfo.orientation);
            this.mFrame = new CameraBridgeViewBase.RotatedCameraFrame(new NativeCameraFrame(this.mCamera), frameRotation);
            if (frameRotation % 180 == 0) {
                this.mFrameWidth = (int)this.mCamera.get(3);
                this.mFrameHeight = (int)this.mCamera.get(4);
            } else {
                this.mFrameWidth = (int)this.mCamera.get(4);
                this.mFrameHeight = (int)this.mCamera.get(3);
            }
            this.mScale = this.getLayoutParams().width == -1 && this.getLayoutParams().height == -1 ? Math.min((float)height / (float)this.mFrameHeight, (float)width / (float)this.mFrameWidth) : 0.0f;
            if (this.mFpsMeter != null) {
                this.mFpsMeter.setResolution(this.mFrameWidth, this.mFrameHeight);
            }
            this.AllocateCache();
        }
        Log.i((String)TAG, (String)("Selected camera frame size = (" + this.mFrameWidth + ", " + this.mFrameHeight + ")"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCamera() {
        NativeCameraView nativeCameraView = this;
        synchronized (nativeCameraView) {
            if (this.mFrame != null) {
                this.mFrame.mFrame.release();
                this.mFrame.release();
            }
            if (this.mCamera != null) {
                this.mCamera.release();
            }
        }
    }

    private class CameraWorker
    implements Runnable {
        private CameraWorker() {
        }

        @Override
        public void run() {
            do {
                if (!NativeCameraView.this.mCamera.grab()) {
                    Log.e((String)NativeCameraView.TAG, (String)"Camera frame grab failed");
                    break;
                }
                NativeCameraView.this.deliverAndDrawFrame(NativeCameraView.this.mFrame);
            } while (!NativeCameraView.this.mStopThread);
        }
    }

    private static class NativeCameraFrame
    implements CameraBridgeViewBase.CvCameraViewFrame {
        private VideoCapture mCapture;
        private Mat mRgba;
        private Mat mGray;

        @Override
        public Mat rgba() {
            this.mCapture.set(6, VideoWriter.fourcc('R', 'G', 'B', '4'));
            this.mCapture.retrieve(this.mRgba);
            Log.d((String)NativeCameraView.TAG, (String)("Retrieved frame with size " + this.mRgba.cols() + "x" + this.mRgba.rows() + " and channels: " + this.mRgba.channels()));
            return this.mRgba;
        }

        @Override
        public Mat gray() {
            this.mCapture.set(6, VideoWriter.fourcc('G', 'R', 'E', 'Y'));
            this.mCapture.retrieve(this.mGray);
            Log.d((String)NativeCameraView.TAG, (String)("Retrieved frame with size " + this.mGray.cols() + "x" + this.mGray.rows() + " and channels: " + this.mGray.channels()));
            return this.mGray;
        }

        public NativeCameraFrame(VideoCapture capture) {
            this.mCapture = capture;
            this.mGray = new Mat();
            this.mRgba = new Mat();
        }

        @Override
        public void release() {
            if (this.mGray != null) {
                this.mGray.release();
            }
            if (this.mRgba != null) {
                this.mRgba.release();
            }
        }
    }

    public static class OpenCvSizeAccessor
    implements CameraBridgeViewBase.ListItemAccessor {
        @Override
        public int getWidth(Object obj) {
            Size size = (Size)obj;
            return (int)size.width;
        }

        @Override
        public int getHeight(Object obj) {
            Size size = (Size)obj;
            return (int)size.height;
        }
    }
}

